#pragma once

#include <boost/system/error_code.hpp>

#include <string>
#include <type_traits>

namespace NNwSmtp::NSO::NRBL {

enum class EError {
    Ok,
    Failed,
    ResponseParseError,
};

class TErrorCategory final : public boost::system::error_category {
public:
    const char* name() const noexcept override {
        return "nwsmtp_so_rbl_http";
    }

    std::string message(int value) const override {
        switch (static_cast<EError>(value)) {
            case EError::Ok:
                return "Ok";
            case EError::Failed:
                return "Http request failed";
            case EError::ResponseParseError:
                return "Failed to parse response";
        }
        return "Unknown error code: " + std::to_string(value);
    }
};

inline const TErrorCategory& getErrorCategory() {
    static TErrorCategory errorCategory;
    return errorCategory;
}

inline auto make_error_code(EError ec) {
    return boost::system::error_code(static_cast<int>(ec), getErrorCategory());
}

} // NNwSmtp::NSO::NRBL

namespace boost::system {

    template <>
    struct is_error_code_enum<NNwSmtp::NSO::NRBL::EError> : std::true_type {};

} // namespace boost::system
