#pragma once

#include "check.h"

#include <mail/library/dsn/options.hpp>
#include <mail/nwsmtp/src/router/router.h>
#include <mail/nwsmtp/src/so/types.h>

#include <string>
#include <vector>

namespace NNwSmtp {

struct TRcpt {
    TRcpt() = default;

    TRcpt(const std::string& email, const std::string& uid)
        : m_name(email)
        , m_uid(uid)
    {
    }

    explicit TRcpt(const std::string& email)
        : TRcpt(email, "")
    {
    }

    bool IsAccepted() const {
        return m_delivery_status != check::CHK_REJECT &&
            m_delivery_status != check::CHK_DISCARD;
    }

    bool IsLocal() const {
        // TODO(MAILDLV-3490) Fix after Gendarme
        return true;
    }

    const std::string m_name;
    DomainType domainType = DomainType::UNKNOWN;

    bool is_alias_ = false;

    long long unsigned m_suid = 0;
    const std::string m_uid;
    std::string m_ml_uid;
    std::string m_default_email;
    std::string country_;
    bool m_phone_confirmed = false;

    std::string m_remote_answer;
    bool need_update_limits;

    check::chk_status m_delivery_status = check::CHK_TEMPFAIL;

    NSO::EResolution m_spam_status = NSO::EResolution::SO_RESOLUTION_SKIP;
    std::vector<std::string> so_classes;

    bool m_spam_status_type = false;

    int m_notify_mode = dsn::Options::NONE;

    bool m_foreign = false;

    // Inactivity period (days).
    // TODO: This field is present here for TSKV logging purposes only and
    // should be removed after NwSMTP daemon and SO filtering separation.
    std::uint32_t inactive_for_ = 0;

    // BigML maillist, not CorpML
    bool is_maillist_ = false;  // no reject maillists by inactives

    std::time_t registrationDate = 0;
};

}  // namespace NNwSmtp
