#include "config.h"
#include "router/settings.h"

namespace NNwSmtp::NRcptTo {

TConfig MakeConfig(std::shared_ptr<const Options> options) {
    return TConfig {
        .Delivery = options->delivery,
        .Blackbox = options->blackbox,
        .CorpListOpts = options->corpList,
        .BigMlOpts = options->bigMlOpts,
        .ToSenderControl = options->deliveryToSenderControl,
        .MaxRecipientsCount = options->smtpOpts.constraints.rcptCountLimit,
        .StrictAsciiRecipient = options->smtpOpts.constraints.strictAsciiRecipient,
        .PercentHack = options->smtpOpts.constraints.allowPercentHack
    };
}

} // namespace NNwSmtp::NRcptTo
