#include "expand_alias.h"
#include "log.h"

#include <mail/nwsmtp/src/aliases.h>
#include <mail/nwsmtp/src/utils.h>

#include <boost/range/algorithm.hpp>

#include <algorithm>

namespace NNwSmtp {

void ExpandAlias(
    const TRcptContext& rcpt,
    const envelope_ptr& envelope,
    bool useDeliveryToSenderControl
) {
    auto& bbData = rcpt.BBData;
    auto aliasEmailsPtr = gAliases.Get(rcpt.Email);
    if (!aliasEmailsPtr) {
        envelope->add_recipient(
            /*rcpt=           */ rcpt.Email,
            /*suid=           */ bbData.Suid,
            /*is_alias=       */ false,
            /*uid=            */ bbData.Uid,
            /*ml_uid=         */ "",
            /*default_email=  */ bbData.DefaultEmail,
            /*country_code=   */ bbData.Country,
            /*domainType=     */ rcpt.DomainType,
            /*notify_mode=    */ rcpt.NotifyMode,
            /*phone_confirmed=*/ bbData.PhoneConfirmed,
            /*is_maillist=    */ bbData.IsMaillist,
            /*regDate=        */ bbData.RegistrationDate
        );
    } else {
        /**
         * If uid exists for rcpt, then we take only first alias address because of uid
         *   deduplication. If there are many aliases for rcpt, then first alias
         *   is always the same as rcpt, thus Postfix is able to expand aliases again.
         *
         *   By the way, we have to send aliases to Postfix (see: m_no_local_relay |= hasAlias).
         *
         *   see: MAILDLV-3142
         */
        for (const auto& aliasEmail: *aliasEmailsPtr) {
            if (NUtil::IsCheckSenderInRcpts(useDeliveryToSenderControl, envelope->m_sender_uid) &&
                boost::iequals(aliasEmail, envelope->m_sender)
            ) {
                envelope->is_sender_in_rcpts_ = true;
            }

            std::int32_t notifyMode = dsn::Options::NEVER;
            auto domainType = DomainType::UNKNOWN;
            if (boost::iequals(aliasEmail, rcpt.Email)) {
                domainType = rcpt.DomainType;
                notifyMode = rcpt.NotifyMode;
            }
            envelope->add_recipient(
                /*rcpt=           */ aliasEmail,
                /*suid=           */ bbData.Suid,
                /*is_alias=       */ true,
                /*uid=            */ bbData.Uid,
                /*ml_uid=         */ "",
                /*default_email=  */ bbData.DefaultEmail,
                /*country_code=   */ bbData.Country,
                /*domainType=     */ domainType,
                /*notify_mode=    */ notifyMode,
                /*phone_confirmed=*/ bbData.PhoneConfirmed,
                /*is_maillist=    */ bbData.IsMaillist,
                /*regDate=        */ bbData.RegistrationDate);
        }
        envelope->m_no_local_relay = true;
    }
}

} // namespace NNwSmtp
