#pragma once

#include "error_code.h"
#include "types.h"

#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/context.h>

#include <functional>

namespace NNwSmtp::NRcptTo {

using TCallback = std::function<void (TErrorCode ec, TResponse resp)>;

struct IRcptToCommand {
    virtual ~IRcptToCommand() = default;

    virtual void Run(TContextPtr context, TRequest req, TCallback cb) = 0;
};

using TRcptToCommandPtr = std::shared_ptr<IRcptToCommand>;

} // namespace NNwSmtp::NRcptTo
