#include "rcpt_to.h"
#include "rcpt_to_impl.h"

namespace NNwSmtp::NRcptTo {

TRcptToCommand::TRcptToCommand(TConfig config,
    NML::TClientPtr ml,
    NBigML::TClientPtr bigMl,
    NRateSrv::TAsyncCheckRecipientClientPtr rateSrvCheckRecipient,
    NBlackBox::TBBChecksPtr bbChecks,
    TRouterPtr router,
    boost::asio::io_context& ioContext)
    : Config(std::move(config))
    , MlClient(std::move(ml))
    , BigMlClient(std::move(bigMl))
    , RateSrvCheckRecipientClient(std::move(rateSrvCheckRecipient))
    , BBChecksClient(std::move(bbChecks))
    , RouterClient(std::move(router))
    , IoContext(ioContext)
{}

void TRcptToCommand::Run(TContextPtr context, TRequest req, TCallback cb) {
    auto impl = std::make_shared<TRcptToCommandImpl>(std::move(context), std::move(req), std::move(cb),
        Config, MlClient, BigMlClient, RateSrvCheckRecipientClient, BBChecksClient, RouterClient, IoContext);
    boost::asio::post(IoContext, std::bind(&TRcptToCommandImpl::Run, std::move(impl)));
}

} // namespace NNwSmtp::NRcptTo
