#pragma once

#include "error_code.h"
#include "types.h"
#include "interface.h"
#include "config.h"

#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/big_ml/client.h>
#include <mail/nwsmtp/src/ml/client.h>
#include <mail/nwsmtp/src/blackbox/bb_checks.h>
#include <mail/nwsmtp/src/router/router.h>

#include <functional>

namespace NNwSmtp::NRcptTo {

class TRcptToCommand : public IRcptToCommand {
public:
    TRcptToCommand(TConfig config,
        NML::TClientPtr ml,
        NBigML::TClientPtr bigMl,
        NRateSrv::TAsyncCheckRecipientClientPtr rateSrvCheckRecipient,
        NBlackBox::TBBChecksPtr bBChecks,
        TRouterPtr router,
        boost::asio::io_context& ioContext);

    void Run(TContextPtr context, TRequest req, TCallback cb) override;

private:
    TConfig Config;
    NML::TClientPtr MlClient;
    NBigML::TClientPtr BigMlClient;
    NRateSrv::TAsyncCheckRecipientClientPtr RateSrvCheckRecipientClient;
    NBlackBox::TBBChecksPtr BBChecksClient;
    TRouterPtr RouterClient;
    boost::asio::io_context& IoContext;
};

} // namespace NNwSmtp::NRcptTo
