#pragma once

#include "types.h"
#include "config.h"
#include "error_code.h"
#include "rcpt_to.h"

#include <mail/nwsmtp/src/router/router.h>

#include <boost/asio.hpp>

namespace NNwSmtp::NRcptTo {

class TRcptToCommandImpl : public std::enable_shared_from_this<TRcptToCommandImpl> {
public:
    TRcptToCommandImpl(
        TContextPtr context,
        TRequest req,
        TCallback cb,
        TConfig config,
        NML::TClientPtr ml,
        NBigML::TClientPtr bigMl,
        NRateSrv::TAsyncCheckRecipientClientPtr rateSrvCheckRecipient,
        NBlackBox::TBBChecksPtr bbChecks,
        TRouterPtr router,
        boost::asio::io_context& ioContext);

    void Run();

private:
    void CheckRecipientAddressSyntax();
    void PercentHack();
    void ExpandMaillist();
    void ResolveBigMlMaillist();
    void HandleBigMlMaillist(TErrorCode ec, NBigML::TResponse resp);
    void ResolveCorpMaillist();
    void HandleCorpMaillist(TErrorCode ec, NML::TResponse resp);

    void SetRcptDsnNotifies(std::map<std::string, std::string> params);

    void CallRouter();
    void HandleCallRouter(TErrorCode ec, Router::Response resp);

    void CheckBB();
    void HandleCheckBB(TErrorCode ec, NBlackBox::TResponse response);

    void CheckRateSrv();
    void HandleRateSrv(TErrorCode ec);

private:
    TContextPtr Context;
    TRequest Req;
    TCallback Callback;
    const TConfig Config;

    NML::TClientPtr MlClient;
    NBigML::TClientPtr BigMlClient;
    NRateSrv::TAsyncCheckRecipientClientPtr RateSrvCheckRecipientClient;
    NBlackBox::TBBChecksPtr BBChecksClient;
    TRouterPtr RouterClient;
    boost::asio::io_context& IoContext;

    check_rcpt_t Rcpt;

    TErrorCode ResponseErrorCode;
    TResponse Response;

    boost::asio::coroutine RunCoro;
};

} // namespace NNwSmtp::NRcptTo
