#include "utils.h"

namespace NNwSmtp::NRcptTo {

bool RecipientsLimitExceeded(const TConfig& config, envelope_ptr envelope) {
    if (config.MaxRecipientsCount) {
        size_t nonAliasRcptsCnt =  std::count_if(envelope->m_rcpts.begin(), envelope->m_rcpts.end(),
            [](const auto& rcpt) { return !rcpt.is_alias_; });
        if (nonAliasRcptsCnt >= config.MaxRecipientsCount.value()) {
            return true;
        }
    }
    return false;
}

bool NeedCheckBBForRcpt(const TConfig& config, const check_rcpt_t& rcpt) {
    return config.Blackbox.checkRcpt
        && (config.Delivery.routing.primary == RoutingSettings::NONE
            || rcpt.RcptContext.DomainType == DomainType::LOCAL)
        && !rcpt.RcptContext.IsAlias;
}

bool NeedCallRouter(const TConfig& config, const check_rcpt_t& rcpt) {
    return config.Delivery.routing.primary != RoutingSettings::NONE
        && !rcpt.RcptContext.IsAlias;
}

void SetRcptDsnNotifies(check_rcpt_t& rcpt, std::string dsnModes) {
    auto& rcptContext = rcpt.RcptContext;
    rcptContext.NotifyMode = dsn::Options::NONE;

    auto lower = boost::to_lower_copy(dsnModes);
    boost::char_separator<char> separator(",");
    boost::tokenizer<boost::char_separator<char> > tokens(lower, separator);
    for (boost::tokenizer<boost::char_separator<char> >::const_iterator it = tokens.begin(); it != tokens.end(); ++it)
    {
        if (*it == "never") {
            rcpt.RcptContext.NotifyMode = dsn::Options::NEVER;
            break;
        } else if (*it == "failure") {
            rcpt.RcptContext.NotifyMode |= dsn::Options::FAILURE;
        } else if (*it == "success") {
            rcpt.RcptContext.NotifyMode |= dsn::Options::SUCCESS;
        } else if (*it == "delay") {
            rcpt.RcptContext.NotifyMode |= dsn::Options::DELAY;
        }
    }
}

}
