#include "rcpts.h"

namespace NNwSmtp {

void TRcpts::Add(const TRcpt& rcpt) {
    if (Contains(rcpt.m_name)) {
        return;
    }
    Rcpts.emplace_back(rcpt);

    auto iter = std::prev(Rcpts.end());
    Emails.emplace(rcpt.m_name, iter);
    // Could be many emails for same uid. Take first added.
    if (!rcpt.m_uid.empty()) {
        Uids.emplace(rcpt.m_uid, iter);
    }
}

void TRcpts::Remove(const std::string& email) {
    if (auto iter = Emails.find(email); iter != Emails.end()) {
        if (auto uidsIter = Uids.find(iter->second->m_uid); uidsIter != Uids.end()) {
            if (uidsIter->second == iter->second) {
                Uids.erase(uidsIter);
            }
        }
        Rcpts.erase(iter->second);
        Emails.erase(iter);
    }
}

bool TRcpts::Contains(const std::string& email) const {
    return GetByEmail(email);
}

const TRcpt* TRcpts::GetByEmail(const std::string& email) const {
    auto iter = Emails.find(email);
    return iter != Emails.end() ? std::addressof(*iter->second) : nullptr;
}

const TRcpt* TRcpts::GetByUid(const std::string& uid) const {
    auto iter = Uids.find(uid);
    return iter != Uids.end() ? std::addressof(*iter->second) : nullptr;
}

void TRcpts::Clear() {
    Rcpts.clear();
    Emails.clear();
    Uids.clear();
}

bool TRcpts::Empty() const {
    return GetSize() == 0;
}

TRcpt* TRcpts::GetByEmail(const std::string& email) {
    return const_cast<TRcpt*>(std::as_const(*this).GetByEmail(email));
}

TRcpt* TRcpts::GetByUid(const std::string& uid) {
    return const_cast<TRcpt*>(std::as_const(*this).GetByUid(uid));
}

}  // namespace NNwSmtp
