#pragma once

#include "rcpt.h"
#include "utils.h"

#include <unordered_map>
#include <list>
#include <string>

namespace NNwSmtp {

class TRcpts {
    using TContainer = std::list<TRcpt>;
    using TIterator = typename TContainer::iterator;
    using TCaseInsensitiveHashMap = std::unordered_map<
        std::string,
        TIterator,
        TCaseInsensitiveHash,
        TCaseInsensitiveCompare>;
public:
    void Add(const TRcpt& rcpt);

    void Remove(const std::string& email);

    bool Contains(const std::string& email) const;

    const TRcpt* GetByEmail(const std::string& email) const;

    const TRcpt* GetByUid(const std::string& uid) const;

    void Clear();

    auto GetSize() const {
        return Rcpts.size();
    }

    bool Empty() const;

    TRcpt* GetByEmail(const std::string& email);

    TRcpt* GetByUid(const std::string& uid);

    auto begin() {
        return Rcpts.begin();
    }

    auto end() {
        return Rcpts.end();
    }

    auto begin() const {
        return Rcpts.cbegin();
    }

    auto end() const {
        return Rcpts.cend();
    }

private:
    TContainer Rcpts;
    TCaseInsensitiveHashMap Emails;
    std::unordered_map<std::string, TIterator> Uids;
};

}  // namespace NNwSmtp
