#include "recognizer_impl.h"

#include <yplatform/module_registration.h>

#include <mail_getter/UTFizer.h>
#include <mimeparser/rfc2047.h>

namespace NNwSmtp {

void TRecognizer::create(const std::string& languageDict, const std::string& languageWeights,
    const std::string& encodingDict) {
        utfizer = Recognizer::create(
            languageDict.c_str(),
            languageWeights.c_str(),
            encodingDict.c_str()
        );
    }

void TRecognizer::init(const yplatform::ptree& pt) {
    create(
        pt.get<std::string>("language_dict").c_str(),
        pt.get<std::string>("language_weights").c_str(),
        pt.get<std::string>("encoding_dict").c_str()
    );
}

std::string TRecognizer::Utfize(const std::string& value) {
    std::string charset;
    std::string result = mulca_mime::decode_rfc2047(value, charset);
    utfizeString(*utfizer, result, charset);
    return result;
}

} // namespace NNwSmtp

DEFINE_SERVICE_OBJECT(NNwSmtp::TRecognizer)
