#pragma once

#include "recognizer.h"

#include <yplatform/module.h>

#include <mail_getter/recognizerWrapper.h>

namespace NNwSmtp {

struct TRecognizer: IRecognizer, yplatform::module {
public:
    void create(const std::string& languageDict, const std::string& languageWeights,
        const std::string& encodingDict);
    void init(const yplatform::ptree& pt);

    std::string Utfize(const std::string& value) override;
private:
    std::shared_ptr<Recognizer::Wrapper> utfizer;
};

} // namespace NNwSmtp
