#pragma once

#include <mail/nwsmtp/src/context.h>

#include <functional>
#include <memory>

namespace NNwSmtp::NDns {

struct IResolverClient {
    using TCallback = std::function<void(boost::system::error_code ec, std::string)>;

    virtual ~IResolverClient() = default;

    virtual void ResolveIp(TContextPtr, std::string, TCallback) = 0;
};

using TResolverClientPtr = std::shared_ptr<IResolverClient>;

} // namespace NNwSmtp::NDns
