#include "client_impl.h"

namespace NNwSmtp::NDns {

void TResolverClient::ResolveIp(TContextPtr context, std::string ip, TCallback callback) {
    auto handler = [ex = Io.get_executor(), callback = std::move(callback)]
        (auto ec, auto response) {
            boost::asio::post(ex, std::bind(callback, std::move(ec), std::move(response)));
        };

    Client->AsyncResolveIp(std::move(context), ip, std::move(handler));
}

} // namespace NNwSmtp::NDns
