#pragma once

#include "client.h"
#include "resolver.h"

#include <boost/asio.hpp>

#include <memory>

namespace NNwSmtp::NDns {

struct TResolverClient: IResolverClient {
    using TClientPtr = std::shared_ptr<TResolver>;

    TResolverClient(TClientPtr client, boost::asio::io_context& io)
        : Client(std::move(client))
        , Io(io) {}

    void ResolveIp(TContextPtr context, std::string ip, TCallback callback) override;

private:
    TClientPtr Client;
    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NDns
