#include "resolver.h"

#include <nwsmtp/ares_options.h>

#include <yplatform/module_registration.h>


namespace NNwSmtp::NDns {

TResolver::TResolver(yplatform::reactor& reactor)
    : Reactor(reactor)
{
}

void TResolver::init(const yplatform::ptree& pt) {
    AresOpts opts;
    opts.init(pt);
    for (size_t i = 0; i < Reactor.size(); ++i) {
        auto resolverPtr = std::make_unique<resolver_t>(*Reactor[i]->io(), opts.resolverOptions);
        auto implPtr = std::make_unique<TImpl<resolver_t>>(*resolverPtr);
        Resolvers.push_back(std::move(resolverPtr));
        Impls.push_back(std::move(implPtr));
   }
}

void TResolver::AsyncResolveIp(
    TContextPtr context,
    const std::string& ip,
    TCallback&& callback)
{
    auto idx = Reactor.get_index();
    Impls[idx]->AsyncResolveIp(std::move(context), ip, std::move(callback));
}

}  // namespace NNwSmtp::NDns

DEFINE_SERVICE_OBJECT(NNwSmtp::NDns::TResolver)
