#pragma once

#include "impl.h"

#include <mail/nwsmtp/src/context.h>

#include <nwsmtp/resolver.h>
#include <yplatform/reactor.h>

#include <functional>

namespace NNwSmtp::NDns {

class TResolver : public yplatform::module {
public:
    using TCallback = std::function<void(boost::system::error_code ec, std::string)>;

    explicit TResolver(yplatform::reactor& reactor);

    void init(const yplatform::ptree& pt);

    virtual void AsyncResolveIp(
        TContextPtr context,
        const std::string& ip,
        TCallback&& callback);

private:
    yplatform::reactor& Reactor;
    std::vector<std::unique_ptr<resolver_t>> Resolvers;
    std::vector<std::unique_ptr<TImpl<resolver_t>>> Impls;
};

}  // namespace NNwSmtp::NDns
