#pragma once

#include "router.h"
#include "settings.h"

#include <nwsmtp/resolver.h>

#include <boost/noncopyable.hpp>
#include <boost/asio.hpp>
#include <memory>

namespace NNwSmtp {

namespace impl {

template <typename Resolver>
struct DnsRouterImpl;

template <typename Resolver>
using ImplPtr = std::shared_ptr<DnsRouterImpl<Resolver>>;

template <typename ImplPtrType>
struct HandleStart;

}   // namespace impl

template <typename Resolver>
class DnsRouter: public Router, private boost::noncopyable {
public:
    DnsRouter(
        boost::asio::io_service& ios,
        const DnsRouterSettings& settings,
        const resolver_options& resolverOptions
    )
        : ios(ios)
        , settings(settings)
        , resolverOptions(resolverOptions)
    {}

    void asyncRoute(TContextPtr context, const std::string& domain, Handler handler) override {
        auto requestImpl = std::make_shared<impl::DnsRouterImpl<Resolver>>(ios, resolverOptions, settings);
        requestImpl->handler = std::move(handler);
        requestImpl->query = domain;
        requestImpl->Context = std::move(context);
        impl::HandleStart<impl::ImplPtr<Resolver>> start(requestImpl);
    }

private:
    boost::asio::io_service& ios;
    const DnsRouterSettings& settings;
    const resolver_options& resolverOptions;
};

}   // namespace NNwSmtp
