#pragma once

#include "router.h"
#include "settings.h"

#include <mail/nwsmtp/src/log.h>

#include <boost/noncopyable.hpp>


namespace NNwSmtp {

class MapBasedRouter: public Router, private boost::noncopyable {
public:
    explicit MapBasedRouter(boost::asio::io_service& ios, const MapBasedRouterSettings& settings)
        : ios(ios)
        , settings(settings)
    {}

    void asyncRoute(TContextPtr ctx, const std::string& domain, Handler handler) override {
        Response response;
        if (settings.myDestDomains->Contains(domain)) {
            response.domainType = DomainType::LOCAL;
        } else {
            response.domainType = DomainType::EXTERNAL;
        }
        NWLOG_CTX(notice, ctx, "", "map route domain=" + domain + ", type=" + std::to_string(
            response.domainType));
        ios.post(std::bind(std::move(handler), boost::system::error_code(), std::move(response)));
    }

private:
    boost::asio::io_service& ios;
    const MapBasedRouterSettings& settings;
};

}   // namespace NNwSmtp
