#pragma once

#include "settings.h"

#include <mail/nwsmtp/src/context.h>

#include <nwsmtp/resolver.h>

#include <boost/asio/io_service.hpp>

#include <functional>
#include <memory>

namespace NNwSmtp {

enum DomainType {
    LOCAL,      // 0
    EXTERNAL,   // 1
    INVALID,    // 2
    UNKNOWN     // 3
};

class Router {
public:
    struct Response {
        Response(DomainType type = DomainType::UNKNOWN): domainType(type) {}
        Response(DomainType type, const std::string& host): domainType(type), mxHost(host) {}

        DomainType domainType = DomainType::UNKNOWN;
        std::string mxHost;
    };
    using Handler = std::function<void (boost::system::error_code, Response)>;

    virtual void asyncRoute(TContextPtr ctx, const std::string& domain, Handler handler) = 0;

    virtual ~Router() {}
};

using TRouterPtr = std::shared_ptr<Router>;

class RouterCall: public Router {
public:
    RouterCall(
        boost::asio::io_service& ios,
        const resolver_options& resolverOptions,
        const RoutingSettings& settings);

    void asyncRoute(TContextPtr ctx, const std::string& domain, Handler handler) override;

private:
    TRouterPtr primary;
    TRouterPtr fallback;
};

}   // namespace NNwSmtp
