#include "settings.h"

namespace NNwSmtp {

void DnsRouterSettings::parse(const yplatform::ptree& conf) {
    auto hostsRange = conf.equal_range("my_mx_hosts");
    myMXHosts.load(hostsRange.first, hostsRange.second);
    timeout = conf.get("timeout", timeout);
    attempts = conf.get("attempts", attempts);
}

void MapBasedRouterSettings::parse(const yplatform::ptree& conf) {
    auto hostsRange = conf.equal_range("my_dest_domains");
    myDestDomains = std::make_shared<TThreadSafeDomainsSet>();
    myDestDomains->Load(hostsRange.first, hostsRange.second);
}

void MapBasedRouterSettings::reload(const yplatform::ptree& conf) {
    auto hostsRange = conf.equal_range("my_dest_domains");
    myDestDomains = std::make_shared<TThreadSafeDomainsSet>();
    myDestDomains->Load(hostsRange.first, hostsRange.second);
}

inline RoutingSettings::Type strToType(const std::string& typeStr) {
    if (typeStr == "map") {
        return RoutingSettings::Type::MAP;
    } else if (typeStr == "dns") {
        return RoutingSettings::DNS;
    } else if (typeStr == "none") {
        return RoutingSettings::Type::NONE;
    } else {
        throw std::runtime_error(std::string("no such routing type: ") + typeStr);
    }
}

void RoutingSettings::init(const yplatform::ptree& pt) {
    primary = strToType(pt.get<std::string>("primary", "none"));
    fallback = strToType(pt.get<std::string>("fallback", "none"));
    mapSettings.parse(pt);
    dnsSettings.parse(pt);
}

void RoutingSettings::reload(const yplatform::ptree& pt) {
    if (primary != Type::NONE && (primary == Type::MAP || fallback == Type::MAP)) {
        mapSettings.reload(pt);
    }
}


}   // namespace NNwSmtp
