#pragma once

#include <mail/nwsmtp/src/domains_set.h>
#include <mail/nwsmtp/src/match.h>

#include <yplatform/ptree.h>
#include <yplatform/time_traits.h>

namespace NNwSmtp {

struct DnsRouterSettings {
    Match myMXHosts;
    yplatform::time_traits::duration timeout = yplatform::time_traits::duration::max();
    unsigned short attempts = 2;

    void parse(const yplatform::ptree& conf);
};

struct MapBasedRouterSettings {
    std::shared_ptr<TThreadSafeDomainsSet> myDestDomains;

    void parse(const yplatform::ptree& conf);
    void reload(const yplatform::ptree& conf);
};

struct RoutingSettings {
    enum Type {
        NONE,   // no check domain
        DNS,    // use dns to check if domain is local
        MAP     // use transport map to check if domain is local
    };
    Type primary = NONE;
    Type fallback = NONE;
    MapBasedRouterSettings mapSettings;
    DnsRouterSettings dnsSettings;

    void init(const yplatform::ptree& pt);
    void reload(const yplatform::ptree& pt);
};

}   // namespace NNwSmtp
