#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::NSettings {

enum EErrorCode {
    EC_OK,
    EC_EXCEPTION,
    EC_BAD_RESPONSE,
    EC_NON_RETRYABLE_STATUS,
    EC_RETRIES_EXCEEDED,
    EC_TVM_SERVICE_TICKET_ERROR
};

} // namespace NNwSmtp::NSettings

namespace boost::system {

template<> struct is_error_code_enum<NNwSmtp::NSettings::EErrorCode> : std::true_type{};

} // namespace boost::system

namespace NNwSmtp::NSettings {

class TErrorCategory final : public boost::system::error_category {
public:
    const char* name() const noexcept override {
        return "Settings client";
    }

    std::string message(int value) const override {
        switch (value) {
            case EC_OK:
                return "Ok";
            case EC_EXCEPTION:
                return "Exception occurred";
            case EC_BAD_RESPONSE:
                return "Bad Settings response";
            case EC_NON_RETRYABLE_STATUS:
                return "HTTP response status is not retryable";
            case EC_RETRIES_EXCEEDED:
                return "Retry possibilities exceeded";
            case EC_TVM_SERVICE_TICKET_ERROR:
                return "Failed to get TVM service ticket";
        }

        return "Unknown error code: " + std::to_string(value);
    }

    static const TErrorCategory& instance() {
        static const TErrorCategory errorCategory;
        return errorCategory;
    }
};

inline boost::system::error_code make_error_code(EErrorCode errorCode) {
    return {errorCode, TErrorCategory::instance()};
}

} // namespace NNwSmtp::NSettings
