#pragma once

#include "types.h"

namespace NNwSmtp::NSettingsAuthorization {

using TCallback = std::function<void (TErrorCode ec, NBlackBox::TResponse)>;

struct ISettingsAuthorization {
    virtual ~ISettingsAuthorization() = default;
    virtual void Run(TContextPtr context, TRequest request, TCallback cb) = 0;
};

using TSettingsAuthorizationPtr = std::shared_ptr<ISettingsAuthorization>;

} // namespace NNwSmtp::NSettingsAuthorization
