#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::SmtpClient {

enum class EError {
    Ok,
    TempFail,
    Rejected
};

} // namespace NNwSmtp::SmtpClient

namespace boost::system {

template <>
struct is_error_code_enum<NNwSmtp::SmtpClient::EError> : std::true_type {};

} // namespace boost::system

namespace NNwSmtp::SmtpClient {

class TErrorCategory final : public boost::system::error_category {

public:
    const char* name() const noexcept override {
        return "nwsmtp_smtp_client";
    }

    std::string message(int value) const override {
        switch (static_cast<EError>(value)) {
            case EError::Ok:
                return "Ok";
            case EError::TempFail:
                return "Temporarily failed";
            case EError::Rejected:
                return "Rejected";
        }
        return "Unknown error code: " + std::to_string(value);
    }
};

inline const TErrorCategory& getErrorCategory() {
    static TErrorCategory errorCategory;
    return errorCategory;
}

inline auto make_error_code(EError ec) {
    return boost::system::error_code(static_cast<int>(ec), getErrorCategory());
}

} // namespace NNwSmtp::SmtpClient
