#pragma once

#include <mail/ymod_smtpclient/include/ymod_smtpclient/call.h>

#include <mail/nwsmtp/src/check.h>
#include <mail/nwsmtp/src/options.h>
#include <mail/nwsmtp/src/envelope.h>
#include <mail/nwsmtp/src/types.h>

#include <boost/asio.hpp>

#include <memory>
#include <functional>
#include <optional>

namespace NNwSmtp::SmtpClient {

class TSmtpClient {
public:
    using TCallback = std::function <void(TErrorCode)>;

    TSmtpClient(std::shared_ptr<ymod_smtpclient::Call> Client, boost::asio::io_context& io)
    : Client(std::move(Client))
    , Io(io) {}

    void Start(
        TCallback callback,
        envelope_ptr envelope,
        const std::string& sessionId,
        const SmtpPoint& host,
        const std::string& protoName,
        const SmtpTimeouts& timeouts,
        const TDomainsSet& filter = TDomainsSet {}
    );

    void Start(
        TCallback callback,
        envelope_ptr envelope,
        envelope::rcpt_list_t& recipients,
        const std::string& sessionId,
        const std::string& sender,
        const SmtpPoint& host,
        const std::string& protoName,
        const SmtpTimeouts& timeouts,
        const std::optional<Options::Targeting>& targeting = std::nullopt,
        const std::string& login = "",
        const std::string& password = "",
        bool oauth = false
    );

private:
    void DoStart(
        TCallback callback,
        const envelope_ptr& envelope,
        const std::string& sessionId,
        const envelope::rcpt_list_t::iterator& rcptBeg,
        const envelope::rcpt_list_t::iterator& rcptEnd,
        const std::string& mailfrom,
        const SmtpPoint& host,
        const std::string& protoName,
        const TDomainsSet& filter,
        const SmtpTimeouts& timeouts,
        const std::optional<Options::Targeting>& targeting = std::nullopt,
        const std::string& login = "",
        const std::string& password = "",
        bool oauth = false
    );

    struct TRequestContext {
        std::string Mailfrom;
        SmtpPoint Host;
        SmtpPoint RealHost;
        envelope_ptr Envelope;
        std::string ProtoName;
        envelope::rcpt_list_t Rcpts;
        yplatform::time_traits::time_point StartedAt;
        std::string SessionId;
    };

    static void HandleSend(
        TCallback callback,
        TRequestContext requestContext,
        TErrorCode ec,
        ymod_smtpclient::Response response
    );

    std::shared_ptr<ymod_smtpclient::Call> Client;
    boost::asio::io_context& Io;
};

using TSmtpClientPtr = std::shared_ptr<TSmtpClient>;

} // namespace NNwSmtp::SmtpClient
