#include "smtp_targeting.h"

#include <string>
#include <functional>
#include <ymod_smtpclient/errors.h>
#include <ymod_smtpclient/smtp_point.h>
#include <ymod_smtpclient/smtp_session.h>

namespace NNwSmtp::SmtpClient::NSmtpTargeting {

void AsyncTargeting(ymod_smtpclient::SmtpSessionPtr smtpSession, const ymod_smtpclient::SmtpPoint& addr,
        THandler handler) {
    smtpSession->asyncConnect(addr.host, addr.port, false, [smtpSession, handler = std::move(handler)](auto ec) {
        if (ec) {
            return handler(ec, std::string());
        }

        smtpSession->asyncGreeting([smtpSession, handler = std::move(handler)](auto ec, auto response) {
            if (ec) {
                return handler(ec, std::string());
            }

            smtpSession->asyncQuit([](auto, auto) {});

            const auto& line = (!response.dataLines.empty() ? response.dataLines[0] : std::string());
            const auto& host = line.substr(0, line.find(' '));

            handler(!host.empty() ? ec : ymod_smtpclient::error::ParseResponseError, host);
        });
    });
}

} // namespace NNwSmtp::SmtpClient::NSmtpTargeting
