#pragma once

#include <mail/nwsmtp/src/check.h>
#include <mail/nwsmtp/src/envelope.h>
#include <mail/ymod_smtpclient/include/ymod_smtpclient/request.h>

namespace NNwSmtp::SmtpClient {

ymod_smtpclient::Request MakeRequest(
    const ymod_smtpclient::SmtpPoint& host,
    const std::string& login,
    const std::string& password,
    bool oauth,
    const std::string& mailfrom,
    const envelope_ptr& envelope,
    const envelope::rcpt_list_t& rcpts
);

ymod_smtpclient::Options MakeOptions(const ymod_smtpclient::Timeouts& timeouts);

check::chk_status MakeCheckStatus(std::uint32_t code);

} // namespace NNwSmtp::SmtpClient
