#include "session_impl.h"

#include <ymod_smtpserver/server.h>
#include <yplatform/module.h>
#include <yplatform/reactor.h>

#include <mail/nwsmtp/src/options.h>
#include <mail/nwsmtp/src/aliases.h>
#include <mail/nwsmtp/src/public_suffix_list.h>

namespace NNwSmtp::NSmtpServer {

class ServerStub: public yplatform::module {
public:
    void init(const yplatform::ptree& conf) {
        auto smtpServer = yplatform::find<ymod_smtpserver::Server>("ymod_smtp_server");
        auto reactor = yplatform::global_reactor_set->get(conf.get<std::string>("reactor"));
        smtpServer->setFactory(std::make_shared<TSessionFactoryImpl>(reactor));

        glog = std::make_shared<TLog>();
        gconfig = std::make_shared<Options>(conf);

        GlobalLoadAliases(conf);
        GlobalLoadPublicSuffixList(gconfig->publicSuffixListFile);
    }
};

}

#include <yplatform/module_registration.h>
DEFINE_SERVICE_OBJECT(NNwSmtp::NSmtpServer::ServerStub)
