#include "smtp_fsm.h"

#include <unordered_map>
#include <unordered_set>

namespace NNwSmtp::NSmtpServer {

const std::unordered_map<SmtpState, std::unordered_set<SmtpState>> SmtpAllowedTransitions = {
    {SmtpState::Start, {SmtpState::Ehlo}},
    {SmtpState::Ehlo, {SmtpState::Ehlo, SmtpState::MailFrom}},
    {SmtpState::MailFrom, {SmtpState::Ehlo, SmtpState::RcptTo}},
    {SmtpState::RcptTo, {SmtpState::Ehlo, SmtpState::RcptTo, SmtpState::Data}},
    {SmtpState::Data, {SmtpState::Ehlo}}
};

bool IsTransitionAllowed(SmtpState prevCmd, SmtpState currCmd) { 
    return SmtpAllowedTransitions.at(prevCmd).contains(currCmd);
}

}
