#include "client_impl.h"
#include "errors.h"
#include "to_protobuf.h"
#include "types_reflection.h"

#include <mail/yreflection/include/yamail/data/deserialization/json_reader.h>

#include <mail/nwsmtp/src/log.h>

#include <functional>

namespace {

auto MakeRequest(std::string body, std::string sessionId) {
    return yhttp::request::POST(
        "/v3/antispam?format=protobuf&output-format=protobuf-json&session_id=" + sessionId,
        std::move(body)
    );
}

std::string ToString(NNwSmtp::NSO::ESOType type) {
    return type == NNwSmtp::NSO::ESOType::SOIn ? "SOIN" : "SOOUT";
}

}

namespace NNwSmtp::NSO {

void TSOClient::Check(TContextPtr context, TRequestPtr request, TCallback callback) {

    std::string body = ToProtobuf(*request);

    auto handler = [ex = Io.get_executor(), callback = std::move(callback)]
        (const auto& ec, auto response) mutable {
            boost::asio::post(ex,
                std::bind(&TSOClient::HandleCheck, std::move(ec), std::move(response), std::move(callback)));
        };
    auto requestId = request->Envelope.ConnectInfo.SessionId;

    Client->async_run(
        context->CreateTaskContext(ToString(SOType).append(":")),
        MakeRequest(std::move(body), requestId),
        std::move(handler)
    );
}

void TSOClient::HandleCheck(
    TErrorCode ec,
    yhttp::response httpResponse,
    TCallback callback
) {
    if (ec) {
        return callback(ec, {});
    }

    if (httpResponse.status != 200) {
        return callback(EError::BadStatus, {});
    }

    TResponse response;
    try {
        yamail::data::deserialization::fromJson<TResponse>(httpResponse.body, response);
    } catch (const std::exception&) {
        return callback(EError::ParseError, {});
    }

    callback({}, std::move(response));
}

} // namespace NNwSmtp::NSO
