#pragma once

#include "client.h"
#include "types.h"

#include <mail/ymod_httpclient/include/ymod_httpclient/cluster_client.h>

#include <boost/asio.hpp>

#include <memory>

namespace NNwSmtp::NSO {

struct TSOClient: ISOClient {
    using TClientPtr = std::shared_ptr<ymod_httpclient::cluster_call>;

    TSOClient(TClientPtr client, ESOType soType, boost::asio::io_context& io)
        : Client(std::move(client))
        , SOType(soType)
        , Io(io) {};

    void Check(TContextPtr ctx, TRequestPtr request, TCallback callback) override;
    void static HandleCheck(TErrorCode, yhttp::response, TCallback);

private:
    TClientPtr Client;
    ESOType SOType = ESOType::SOIn;
    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NSO
