#pragma once

#include <yplatform/ptree.h>

#include <chrono>
#include <set>
#include <vector>
#include <unordered_set>

namespace NNwSmtp::NSO {

enum class ESpamPolicy {
    DISCARD,
    REJECT,
    FIELD_MARK
};

struct TOptions {
    TOptions() = default;
    void Read(const yplatform::ptree&);

    std::unordered_set<std::string> InternalHeaders;

    std::string ReplyTextMalicious = "Message rejected under suspicion of SPAM";
    std::string ReplyTextSpam = "Message rejected under suspicion of SPAM";
    std::string ReplyTextDiscard;
    std::string ClusterName;
    std::string SoClient = "so_in_client";

    bool Check = false;
    bool AddXspamFlag = false;
    bool DryRun = false;
    bool CheckInactivity = true;
    bool RejectForInactive = false;

    std::uint32_t InactivityThreshold = 100;
    std::chrono::days NewUserPeriod = std::chrono::days::zero();
    std::vector<std::set<std::string>> RejectedTypes;

    ESpamPolicy ActionSpam = ESpamPolicy::FIELD_MARK;
    ESpamPolicy ActionMalicious = ESpamPolicy::REJECT;
};

} // namespace NNwSmtp::NSO
