#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::NSO {

enum class EError {
    Ok,
    ParseError,
    BadStatus
};

} // NNwSmtp::NSO

namespace boost::system {

template <>
struct is_error_code_enum<NNwSmtp::NSO::EError> : std::true_type {};

} // namespace boost::system

namespace NNwSmtp::NSO {

class TErrorCategory final : public boost::system::error_category {

public:
    const char* name() const noexcept override {
        return "nwsmtp_so";
    }

    std::string message(int value) const override {
        switch (static_cast<EError>(value)) {
            case EError::Ok:
                return "Ok";
            case EError::ParseError:
                return "Failed to parse response";
            case EError::BadStatus:
                return "Request to ended with not 200 status code";
        }
        return "Unknown error code: " + std::to_string(value);
    }
};

inline const TErrorCategory& getErrorCategory() {
    static TErrorCategory errorCategory;
    return errorCategory;
}

inline auto make_error_code(EError ec) {
    return boost::system::error_code(static_cast<int>(ec), getErrorCategory());
}

} // namespace NNwSmtp::NSO
