#pragma once

#include "config.h"

#include <mail/nwsmtp/src/dmarc.h>
#include <mail/nwsmtp/src/envelope.h>

#include <optional>
#include <string>
#include <vector>

namespace NNwSmtp::NSO {

struct TConnectInfo {
    std::string Host;
    std::string Ip;
    std::string Domain;
    std::string SessionId;
};

struct TEmail {
    std::string Email;
};

struct TEmailInfo {
    TEmail Address;
    std::optional<std::string> Uid;
    std::optional<std::string> Suid;
    std::optional<std::string> Country;
    std::optional<std::string> Karma;
    std::optional<std::string> KarmaStatus;
    bool IsMaillist = false;
};

struct TEnvelope {
    TConnectInfo ConnectInfo;
    // EMAIL_TYPE_REGULAR | EMAIL_TYPE_MAILISH | EMAIL_TYPE_RPOP | EMAIL_TYPE_RESTORE | EMAIL_TYPE_DELAYED
    std::string EmailType = "EMAIL_TYPE_REGULAR";
    std::optional<TEmailInfo> MailFrom;
    std::vector<TEmailInfo> Rcpts;
    std::string Timestamp;
};

struct TRequest {
    TRequest(TEnvelope envelope, std::string rawEmail, bool dryRun);

    TEnvelope Envelope;
    std::string RawEmail;
    bool DryRun = false;
    bool GetDeliveryLog = false;
};

using TRequestPtr = std::shared_ptr<TRequest>;

struct TBuildSoHttpRequestParams {
    std::string SessionId;
    std::string EnvelopeId;

    std::string RemoteHost;
    std::string RemoteIp;
    std::optional<std::string> HeloHost;

    std::optional<std::string> EmailType;
    std::optional<TEmailInfo> MailFrom;
    std::vector<TEmailInfo> Rcpts;
    std::string Timestamp;

    std::string SoClusterName;
    std::optional<std::string> Spf;
    std::optional<std::string> Dmarc;
    std::optional<std::string> AuthResults;
    std::optional<std::string> MessageId;
    std::optional<std::string> Mailish;
    const THeaderStorageImpl& Headers;
    const std::unordered_set<std::string>& InternalHeaders;

    TBufferRange MessageBody;
    bool IsDryRun;
};

std::string BuildSoHeaders(const TBuildSoHttpRequestParams& args, const std::string& queueId);
TRequestPtr BuildSoHttpRequest(TBuildSoHttpRequestParams args);

} // namespace NNwSmtp::NSO
