#include "to_protobuf.h"

#include <mail/so/api/so_api.pb.h>

#include <util/string/cast.h>

namespace {

void ToProtobuf(const NNwSmtp::NSO::TConnectInfo& connectInfo, mail::so::api::v1::ConnectInfo* pbConnectInfo) {
    *pbConnectInfo->mutable_remote_host() = connectInfo.Host;
    *pbConnectInfo->mutable_remote_ip() = connectInfo.Ip;
    *pbConnectInfo->mutable_remote_domain() = connectInfo.Domain;
    *pbConnectInfo->mutable_session_id() = connectInfo.SessionId;
}

void ToProtobuf(const NNwSmtp::NSO::TEmail& email, mail::so::api::v1::Email* pbEmail) {
    *pbEmail->mutable_email() = email.Email;
}

void ToProtobuf(const NNwSmtp::NSO::TEmailInfo& emailInfo, mail::so::api::v1::EmailInfo* pbEmailInfo) {
    ToProtobuf(emailInfo.Address, pbEmailInfo->mutable_address());

    if (emailInfo.Uid.has_value()) {
        i64 uid;
        if (TryFromString(emailInfo.Uid.value(), uid)) {
            pbEmailInfo->mutable_uid()->set_value(uid);
        }
    }

    if (emailInfo.Suid.has_value()) {
        i64 suid;
        if (TryFromString(emailInfo.Suid.value(), suid)) {
            pbEmailInfo->mutable_suid()->set_value(suid);
        }
    }

    if (emailInfo.Country.has_value()) {
        *pbEmailInfo->mutable_country() = emailInfo.Country.value();
    }

    if (emailInfo.Karma.has_value()) {
        i64 karma;
        if (TryFromString(emailInfo.Karma.value(), karma)) {
            pbEmailInfo->mutable_karma()->set_value(karma);
        }
    }

    if (emailInfo.KarmaStatus.has_value()) {
        i64 karmaStatus;
        if (TryFromString(emailInfo.KarmaStatus.value(), karmaStatus)) {
            pbEmailInfo->mutable_karma_status()->set_value(karmaStatus);
        }
    }

    pbEmailInfo->set_is_maillist(emailInfo.IsMaillist);
}

void ToProtobuf(const NNwSmtp::NSO::TEnvelope& envelope, mail::so::api::v1::SmtpEnvelope* pbEnvelope) {
    ToProtobuf(envelope.ConnectInfo, pbEnvelope->mutable_connect_info());
    i64 timestamp;
    if (TryFromString(envelope.Timestamp, timestamp)) {
        pbEnvelope->mutable_email_timestamp()->set_value(timestamp);
    }

    if (envelope.EmailType == "EMAIL_TYPE_REGULAR") {
        pbEnvelope->set_email_type(mail::so::api::v1::EMAIL_TYPE_REGULAR);
    } else if (envelope.EmailType == "EMAIL_TYPE_MAILISH") {
        pbEnvelope->set_email_type(mail::so::api::v1::EMAIL_TYPE_MAILISH);
    } else if (envelope.EmailType == "EMAIL_TYPE_RPOP") {
        pbEnvelope->set_email_type(mail::so::api::v1::EMAIL_TYPE_RPOP);
    } else if (envelope.EmailType == "EMAIL_TYPE_RESTORE") {
        pbEnvelope->set_email_type(mail::so::api::v1::EMAIL_TYPE_RESTORE);
    } else if (envelope.EmailType == "EMAIL_TYPE_DELAYED") {
        pbEnvelope->set_email_type(mail::so::api::v1::EMAIL_TYPE_DELAYED);
    }

    if (envelope.MailFrom.has_value()) {
        ToProtobuf(envelope.MailFrom.value(), pbEnvelope->mutable_mail_from());
    }

    google::protobuf::RepeatedPtrField<mail::so::api::v1::EmailInfo>* recipients = pbEnvelope->mutable_recipients();
    for (const auto& rcpt: envelope.Rcpts) {
        ToProtobuf(rcpt, recipients->Add());
    }
}

void ToProtobuf(const NNwSmtp::NSO::TRequest& request, mail::so::api::v1::SoRequest* pbRequest) {
    ToProtobuf(request.Envelope, pbRequest->mutable_smtp_envelope());
    *pbRequest->mutable_raw_email() = request.RawEmail;
    pbRequest->set_dry_run(request.DryRun);
    pbRequest->set_get_delivery_log(request.GetDeliveryLog);
}

}  // namespace anonymous

std::string NNwSmtp::NSO::ToProtobuf(const NNwSmtp::NSO::TRequest& request) {
    mail::so::api::v1::SoRequest soRequest;
    ::ToProtobuf(request, &soRequest);
    return soRequest.SerializeAsStringOrThrow();
}
