#pragma once

#include <mail/nwsmtp/src/types.h>

#include <cstdint>
#include <optional>
#include <string>
#include <vector>

namespace NNwSmtp::NSO {

enum class ESOType {
    SOIn,
    SOOut
};

enum class EResolution {
    SO_RESOLUTION_SKIP,
    SO_RESOLUTION_INVALID,
    SO_RESOLUTION_ACCEPT,
    SO_RESOLUTION_REJECT,
    SO_RESOLUTION_SPAM
};

enum class EForwardType {
    FORWARD_TYPE_INVALID,
    FORWARD_TYPE_MXBACK,
    FORWARD_TYPE_WHITE,
    FORWARD_TYPE_GRAY
};

struct TPersonalResolution {
    std::string Uid;
    EResolution Resolution;
    std::vector<std::string> SoClasses;
};

struct TActivityInfo {
    std::string Uid;
    std::optional<std::int64_t> Status;
};

struct TOutParameters {
    std::optional<EForwardType> Type;
    std::optional<bool> ForeignMx;
};

struct TResponse {
    EResolution Resolution;
    std::optional<bool> DenyGraylist = false;
    std::optional<TOutParameters> OutParameters;
    std::optional<std::vector<TActivityInfo>> ActivityInfos;
    std::vector<std::string> SoClasses;
    std::optional<std::vector<TPersonalResolution>> PersonalResolutions;
};

using TCallback = std::function<void(TErrorCode, TResponse)>;

} // namespace NNwSmtp::NSO
