#pragma once

#include "request.h"
#include "types.h"

#include <yamail/data/reflection/reflection.h>

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TConnectInfo,
    YREFLECTION_MEMBER_RENAMED(std::string, remote_host, Host)
    YREFLECTION_MEMBER_RENAMED(std::string, remote_ip, Ip)
    YREFLECTION_MEMBER_RENAMED(std::string, remote_domain, Domain)
    YREFLECTION_MEMBER_RENAMED(std::string, session_id, SessionId)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TEmail,
    YREFLECTION_MEMBER_RENAMED(std::string, email, Email)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TEmailInfo,
    YREFLECTION_MEMBER_RENAMED(NNwSmtp::NSO::TEmail, address, Address)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, uid, Uid)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, suid, Suid)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, country, Country)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, karma, Karma)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, karma_status, KarmaStatus)
    YREFLECTION_MEMBER_RENAMED(bool, is_maillist, IsMaillist)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TEnvelope,
    YREFLECTION_MEMBER_RENAMED(NNwSmtp::NSO::TConnectInfo, connect_info, ConnectInfo)
    YREFLECTION_MEMBER_RENAMED(std::string, email_type, EmailType)
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NSO::TEmailInfo>, mail_from, MailFrom)
    YREFLECTION_MEMBER_RENAMED(std::vector<NNwSmtp::NSO::TEmailInfo>, recipients, Rcpts)
    YREFLECTION_MEMBER_RENAMED(std::string, email_timestamp, Timestamp)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TRequest,
    YREFLECTION_MEMBER_RENAMED(NNwSmtp::NSO::TEnvelope, smtp_envelope, Envelope)
    YREFLECTION_MEMBER_RENAMED(std::string, raw_email,  RawEmail)
    YREFLECTION_MEMBER_RENAMED(bool, dry_run, DryRun)
    YREFLECTION_MEMBER_RENAMED(bool, get_delivery_log, GetDeliveryLog)
)

YREFLECTION_ADAPT_ENUM(NNwSmtp::NSO::EResolution,
    SO_RESOLUTION_SKIP,
    SO_RESOLUTION_INVALID,
    SO_RESOLUTION_ACCEPT,
    SO_RESOLUTION_REJECT,
    SO_RESOLUTION_SPAM
)

YREFLECTION_ADAPT_ENUM(NNwSmtp::NSO::EForwardType,
    FORWARD_TYPE_INVALID,
    FORWARD_TYPE_MXBACK,
    FORWARD_TYPE_WHITE,
    FORWARD_TYPE_GRAY
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TPersonalResolution,
    YREFLECTION_MEMBER_RENAMED(std::string, uid, Uid)
    YREFLECTION_MEMBER_RENAMED(NNwSmtp::NSO::EResolution, resolution, Resolution)
    YREFLECTION_MEMBER_RENAMED(std::vector<std::string>, so_classes, SoClasses)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TActivityInfo,
    YREFLECTION_MEMBER_RENAMED(std::string, uid, Uid)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::int64_t>, activity_status, Status)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TOutParameters,
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NSO::EForwardType>, forward_type, Type)
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, foreign_mx, ForeignMx)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NSO::TResponse,
    YREFLECTION_MEMBER_RENAMED(NNwSmtp::NSO::EResolution, resolution, Resolution)
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, deny_graylist, DenyGraylist)
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NSO::TOutParameters>, out_parameters, OutParameters)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::vector<NNwSmtp::NSO::TActivityInfo>>, activity_infos, ActivityInfos)
    YREFLECTION_MEMBER_RENAMED(std::vector<std::string>, so_classes, SoClasses)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::vector<NNwSmtp::NSO::TPersonalResolution>>, personal_resolutions, PersonalResolutions)
)
