#include "utils.h"

namespace NNwSmtp::NSO {

std::string ResolutionToString(EResolution resolution) {
    switch (resolution) {
        case EResolution::SO_RESOLUTION_ACCEPT:
            return "1";
        case EResolution::SO_RESOLUTION_SPAM:
            return "4";
        case EResolution::SO_RESOLUTION_REJECT:
            return "256";
        case EResolution::SO_RESOLUTION_SKIP:
            return "0";
        default:
            return "-1";
    }
}

EResolution ResolutionFromString(std::string resolution) {
    if (resolution == "1") {
        return EResolution::SO_RESOLUTION_ACCEPT;
    } else if (resolution == "4") {
        return EResolution::SO_RESOLUTION_SPAM;
    } else if (resolution == "256") {
        return EResolution::SO_RESOLUTION_REJECT;
    } else if (resolution == "0") {
        return EResolution::SO_RESOLUTION_SKIP;
    } else {
        return EResolution::SO_RESOLUTION_INVALID;
    }
}

std::string Report(EResolution resolution) {
    switch (resolution) {
        case EResolution::SO_RESOLUTION_ACCEPT:
            return "accept";
        case EResolution::SO_RESOLUTION_SPAM:
            return "spam";
        case EResolution::SO_RESOLUTION_REJECT:
            return "reject";
        default:
            return "error";
    }
}

} // namespace NNwSmtp::NSO
