#pragma once

#include <mail/libyadns/include/yadns/resolver_options.h>

#include <boost/asio.hpp>

#include <functional>
#include <optional>
#include <string>

typedef std::function<void(const std::string&)> spf_logger_t;

struct spf_parameters
{
    boost::asio::ip::address ip;
    std::string domain;
    std::string from;
    spf_logger_t logger;
};

template <class Handle>
void async_check_SPF(boost::asio::io_service& ios, const spf_parameters& p, const resolver_options& resolver_options,
        Handle handle, int debug = 0);

struct spf_check_interface
{
    using callback_t = std::function<void(std::optional<std::string>, std::optional<std::string>)>;

    virtual ~spf_check_interface() = default;

    virtual void start(boost::asio::io_service&, const spf_parameters&,
        const resolver_options&, callback_t, int = 0) = 0;

    virtual void stop() = 0;

    virtual bool is_inprogress() const = 0;
};

struct spf_check_impl;

class spf_check
{
    boost::shared_ptr<spf_check_impl> impl_;

  public:
    using callback_t = std::function<void(std::optional<std::string>, std::optional<std::string>)>;
    spf_check();

    void start(boost::asio::io_service& ios, const spf_parameters& p,
        const resolver_options& resolver_options, callback_t handle, int debug = 0);

    void stop();

    bool is_inprogress() const;
};
