#pragma once

#include <options.h>
#include <mail/sova/include/nwsmtp/ares_options.h>

#include <memory>

namespace NNwSmtp::NSPF {

struct TConfig {
    resolver_options ResolverOptions;
    Options::SPFOpts SPFOpts;

    explicit TConfig(resolver_options resolverOptions, Options::SPFOpts spfOpts)
        : ResolverOptions(std::move(resolverOptions))
        , SPFOpts(std::move(spfOpts)) { }
};

using TConfigPtr = std::shared_ptr<TConfig>;

TConfigPtr MakeConfig(std::shared_ptr<Options>);

} // namespace NNwSmtp::NSPF
