#pragma once

#include "aspf.h"

#include <mail/nwsmtp/src/types.h>

#include <boost/date_time/posix_time/posix_time_duration.hpp>
#include <boost/optional.hpp>
#include <boost/system/error_code.hpp>

#include <functional>
#include <memory>

namespace NNwSmtp::NSPF {

struct TResponse {
    std::optional<std::string> Result;
    std::optional<std::string> Expl;
};

using TCallback = std::function<void(TErrorCode, TResponse)>;

struct ISPFCheckClient {
    virtual ~ISPFCheckClient() = default;

    virtual void Check(
        std::string, std::string, boost::asio::ip::address, spf_logger_t, TCallback) const = 0;
};

using TSPFCheckClientPtr = std::shared_ptr<ISPFCheckClient>;

} // namespace NNwSmtp::NSPF
