#pragma once

#include <mail/nwsmtp/src/header_storage.h>

#include <yplatform/zerocopy/segment.h>

#include <boost/range/iterator_range.hpp>
#include <boost/system/error_code.hpp>

#include <chrono>


namespace NNwSmtp {

using TBuffer = yplatform::zerocopy::segment;
using TBufferIterator = TBuffer::const_iterator;
using TBufferRange = boost::iterator_range<TBuffer::const_iterator>;
using TErrorCode = boost::system::error_code;

using TSystemClock = std::chrono::system_clock;
using TSystemTimePoint = TSystemClock::time_point;
using TMilliSeconds = std::chrono::milliseconds;

using TFragmentConstIterator = TBuffer::fragment_type::const_iterator;

using THeaderStorageImpl = THeaderStorage<TBufferRange>;

}  // namespace NNwSmtp
