#pragma once

#include <mail/nwsmtp/src/xyandexhint/extractor.h>

#include <nwsmtp/remote_point.h>
#include <mail/nwsmtp/src/router/settings.h>

#include <ymod_httpclient/call.h>
#include <ymod_httpclient/cluster_client.h>
#include <ymod_smtpclient/smtp_point.h>
#include <ymod_tvm/module.h>
#include <yplatform/zerocopy/streambuf.h>

#include <boost/asio.hpp>

#include <string>
#include <unordered_set>
#include <regex>
#include "types.h"
#include "header_storage.h"

namespace NNwSmtp {
namespace detail {

ymod_smtpclient::SmtpPoint remote_point_to_smtp(const remote_point& rp);

} // namespace detail

struct TCaseInsensitiveHash {
    std::size_t operator()(const std::string& email) const noexcept;
};

struct TCaseInsensitiveCompare {
    bool operator()(const std::string& lhs, const std::string& rhs) const;
};

using TCaseInsensitiveHashSet = std::unordered_set<
    std::string,
    TCaseInsensitiveHash,
    TCaseInsensitiveCompare>;

std::vector<NHint::TParamsContainer> GetNonpersonalHintsParameters(THeaderStorageImpl::THeaderStorageRange headers);

bool Contains(const std::vector<NHint::TParamsContainer>& hints, const std::string& parameter);

std::optional<std::string> GetFirstValueInOrderOfAddition(
    const std::vector<NHint::TParamsContainer>& hints,
    const std::string& parameter);

} // namespace NNwSmtp

namespace NNwSmtp::NUtil {

TSystemTimePoint GetNow();

int64_t GetNowMs();

std::string ToString(const TBufferRange& range);

template <typename ...TArgs>
auto MakeSegment(TArgs&&... args) {
    yplatform::zerocopy::streambuf buf;
    std::ostream os(&buf);
    (os << ... << args) << std::flush;
    return buf.detach(buf.end());
}

inline void AppendToSegment(yplatform::zerocopy::segment& segm, const std::string& str) {
    segm.append(NUtil::MakeSegment(str));
}

std::string GetRfc822Date(std::time_t time);

std::string GetRfc822DateNow();

using TGetClusterClient = std::function<std::shared_ptr<ymod_httpclient::cluster_call>()>;
TGetClusterClient MakeGetClusterClient(const std::string& moduleName);

using TGetTvm2Module = std::function<std::shared_ptr<ymod_tvm::tvm2_module>()>;
TGetTvm2Module MakeGetTvm2Module(const std::string& moduleName);

boost::asio::ip::address ToIpV4IfPossible(boost::asio::ip::address addr);

template<class... T>
std::string JoinStrings(const T&... t) {
    static_assert((std::is_same_v<std::decay_t<T>, std::string> && ...), "Need std::string");

    std::string result{};
    result.reserve((t.size() + ...));
    ((result += t), ...);
    return result;
}

bool IsCheckSenderInRcpts(bool useDeliveryToSenderControl, const std::string& senderUid);

bool IsRouting();

} // namespace NNwSmtp::NUtil

std::string rev_order_av4_str(const boost::asio::ip::address_v4&,
    const std::string& d = "in-addr.arpa.");
std::string rev_order_av6_str(const boost::asio::ip::address_v6&,
    const std::string& d = "ip6.arpa.");
std::string rev_order_str(boost::asio::ip::address);

bool parse_email(const std::string& email,
    std::string& local, std::string& domain);

std::string GetDomainFromEmail(const std::string& email);

std::string removePlusFromEmail(const std::string& email);

std::string url_encode2(const std::string &_buffer);

std::string format_notify_mode(int mode);

bool Contains(std::string text, std::string pattern);

void encode_to_base64(const std::string& to_encode, std::string& dst);

std::string encode_to_base64(const std::string& to_encode);

bool is_invalid(char _elem);

bool address_valid(const std::string& addr, bool checkSyntax);

void squash_consecutive_spaces(std::string& str);

// Check X-Request-Id value validity.
bool request_id_valid(const std::string& r);

bool is_corp(const std::string& cluster);

std::string GetTimestamp();

std::string GetUnixTimestamp();

std::string IpToBytes(const std::string& ip);

bool IsASCII(const std::string& value);
