#include "handle_restore.h"

#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/delivery/sync/sync.h>
#include <mail/nwsmtp/src/delivery/sync/types.h>
#include <mail/nwsmtp/src/log.h>
#include <mail/nwsmtp/src/web/restore/reflection.h>
#include <mail/nwsmtp/src/web/restore/make_args.h>
#include <mail/nwsmtp/src/web/restore/make_response.h>
#include <mail/nwsmtp/src/web/utils/exception.h>

#include <mail/yreflection/include/yamail/data/deserialization/json_reader.h>

namespace NNwSmtp::NWeb {

void TRestore::operator() (
    THttpStream stream,
    std::string uid,
    std::string requestId,
    boost::asio::io_context&
) const {
    const auto& request = stream->request();
    NDlv::TEnvelopeInfo envelopeInfo;
    NDlv::TMailInfo mailInfo;
    NDlv::TUserInfo userInfo;
    NDlv::TOptions options;
    const auto ctx = boost::make_shared<TContext>(request->context->uniq_id(), "", gconfig->clusterName, gconfig->hostName);

    try {
        auto restoreRequest = yamail::data::deserialization::fromJson<NRestore::TRequest>(
            {request->raw_body.cbegin(), request->raw_body.cend()}
        );
        envelopeInfo = NRestore::MakeEnvelopeInfo(stream, requestId);
        mailInfo = NRestore::MakeMailInfo(restoreRequest);
        userInfo = NRestore::MakeUserInfo(restoreRequest, uid);
        options.DlvType = NDlv::EDlvType::Restore;
    } catch (const std::exception& exc) {
        NWLOG_CTX(error, ctx, "handle_restore", "request parsing error: " + std::string{exc.what()});
        return throw TArgumentParseException{"request parsing error: " + std::string{exc.what()}};
    }

    try {
        return NDlv::RunSyncDelivery(ctx, envelopeInfo, mailInfo, userInfo, options, TBuffer{},
            [stream = stream] (auto ec, auto result) {
                NRestore::MakeResponse(stream, ec, result);
            });
    } catch (const std::exception& exc) {
        NWLOG_CTX(error, ctx, "handle_restore", exc.what());
        throw;
    }
}

} // namespace NNwSmtp::NWeb
