#include "handle_save.h"

#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/delivery/sync/sync.h>
#include <mail/nwsmtp/src/delivery/sync/types.h>
#include <mail/nwsmtp/src/log.h>
#include <mail/nwsmtp/src/web/save/make_args.h>
#include <mail/nwsmtp/src/web/save/make_response.h>
#include <mail/nwsmtp/src/web/utils/exception.h>
#include <mail/nwsmtp/src/web/utils/get_param.h>

namespace NNwSmtp::NWeb {

void TSave::operator() (
    THttpStream stream,
    std::string uid,
    std::string email,
    std::string requestId
) const {
    const auto& request = stream->request();
    NDlv::TEnvelopeInfo envelopeInfo;
    NDlv::TMailInfo mailInfo;
    NDlv::TUserInfo userInfo;
    NDlv::TOptions options;

    const auto ctx = boost::make_shared<TContext>(request->context->uniq_id(), "", gconfig->clusterName, gconfig->hostName);
    try {
        if (request->raw_body.size() == 0) {
            throw std::invalid_argument("empty message in request body");
        }

        envelopeInfo = NSave::MakeEnvelopeInfo(stream, requestId);
        mailInfo = NSave::MakeMailInfo(request);
        userInfo = NSave::MakeUserInfo(email, uid);
        options =  NSave::MakeOptions(request);
    } catch (const std::exception& exc) {
        NWLOG_CTX(error, ctx, "handle_save", "request parsing error: " + std::string{exc.what()});
        return throw TArgumentParseException{"request parsing error: " + std::string{exc.what()}};
    }

    try {
        return NDlv::RunSyncDelivery(ctx, envelopeInfo, mailInfo, userInfo, options, request->raw_body,
            [stream = stream] (auto ec, auto result) {
                NSave::MakeResponse(stream, ec, result);
            });
    } catch (const std::exception& exc) {
        NWLOG_CTX(error, ctx, "handle_save", exc.what());
        throw;
    }
}

} // namespace NNwSmtp::NWeb
