#include "handle_send_mail.h"

#include <mail/nwsmtp/src/log.h>
#include <mail/nwsmtp/src/web/send_mail/make_args.h>
#include <mail/nwsmtp/src/web/send_mail/make_response.h>
#include <mail/nwsmtp/src/web/send_mail/send_mail.h>
#include <mail/nwsmtp/src/web/utils/exception.h>

namespace NNwSmtp::NWeb {

void TSendMail::operator() (
    THttpStream stream,
    std::string uid,
    std::string fromEmail,
    std::string service,
    std::string detectSpam,
    std::string detectVirus,
    boost::asio::io_context& io
) const {
    const auto& request = stream->request();
    auto ctx = boost::make_shared<TContext>(request->context->uniq_id(), "", gconfig->clusterName, gconfig->hostName);
    NSendMail::TArgsPtr args;

    try {
        args = NSendMail::MakeArgs(request, std::move(uid), std::move(fromEmail),
            std::move(service), std::move(detectSpam), std::move(detectVirus));
    } catch (const std::exception& exc) {
        NWLOG_CTX(error, ctx, "handle_send_mail", "Request parsing error: " + std::string{exc.what()});
        return throw TArgumentParseException{exc.what()};
    }

    try {
        NSendMail::StartSendMail(std::bind(NSendMail::Handler, stream, std::placeholders::_1), args, io);
    } catch (const std::exception& exc) {
        NWLOG_CTX(error, ctx, "handle_send_mail", exc.what());
        throw exc;
    }
}

} // namespace NNwSmtp::NWeb
