#include "handle_store_mailish.h"

#include "sync_request.h"
#include "sync_response.h"

#include <mail/nwsmtp/src/log.h>
#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/web/utils/exception.h>
#include <mail/nwsmtp/src/web/utils/set_return_code.h>

namespace NNwSmtp::NWeb {

void TStoreMailish::operator() (
    THttpStream stream,
    std::string uid,
    std::string fid,
    std::string externalImapId
) const {
    NSync::TRequest request{};
    try {
        request = NSync::ParseRequest<TMailishTag>(stream);
    } catch (const std::exception& exc) {
        return throw TArgumentParseException{"Request parsing error: " + std::string{exc.what()}};
    }
    auto [envInfo, mailInfo, userInfo, options, message] = std::move(request);

    mailInfo.Fid = fid;
    mailInfo.ExternalImapId = externalImapId;

    userInfo.Uid = uid;

    options.DetectSpam = true;
    options.DlvType = NDlv::EDlvType::Mailish;

    auto context{boost::make_shared<TContext>(envInfo.SessionId, envInfo.EnvId, gconfig->clusterName, gconfig->hostName)};

    try {
        return NDlv::RunSyncDelivery(context, envInfo, mailInfo, userInfo, options, message,
            [stream = stream] (auto ec, auto result) {
                if (ec) {
                    SetReturnCode(stream, NSync::ToErrorCode(ec));
                    return NSync::RespondError(stream, ec);
                }
                return NSync::RespondSuccess<TMailishTag>(stream, result);
            });
    } catch (const std::exception& exc) {
        NWLOG_CTX(error, context, "handle_store_mailish", exc.what());
        throw;
    }
}

}  // namespace NNwSmtp::NWeb
