#include "request.h"

#include <library/cpp/json/json_reader.h>

namespace NNwSmtp::NWeb {

std::pair<TBuffer, TBuffer> ReadMultiPartBody(const std::vector<ymod_webserver::content_part>& parts) {
    if (parts.size() != 2) {
        throw std::logic_error("Expected two parts in body, got: " + std::to_string(parts.size()));
    }
    const auto& json = parts.front();
    if (json.content.type != "application" || json.content.subtype != "json") {
        throw std::logic_error("Expected application/json at first place, got: "
            + json.content.type + "/" + json.content.subtype);
    }
    const auto& mime = *std::next(parts.begin());
    if (mime.content.type != "message" || mime.content.subtype != "rfc822") {
        throw std::logic_error("Expected message/rfc822 at second place, got: "
            + mime.content.type + "/" + mime.content.subtype);
    }
    return {json.body, mime.body};
}

std::pair<NJson::TJsonValue, TBuffer> ParseBody(const ymod_webserver::request_ptr& request) {
    if (!request) {
        throw std::runtime_error("Empty request is not allowed");
    }
    if (request->content.type != "multipart") {
        throw std::logic_error("Expected multipart body, got: " + request->content.type);
    }
    auto [json, mime] = ReadMultiPartBody(request->childs);

    NJson::TJsonValue value;
    NJson::ReadJsonTree(std::string{json.cbegin(), json.cend()}, &value, /*throwOnError*/true);

    return {value, mime};
}

}  // namespace NNwSmtp::NWeb
